if exists(select  1 from sys.procedures where name = 'p_plug_Farma_tipoRegistro_vinte')
    begin 
		drop procedure p_plug_Farma_tipoRegistro_vinte;
    end;
go

--p_plug_Farma_tipoRegistro_vinte 9,'20190319'
create procedure p_plug_Farma_tipoRegistro_vinte (@filial int, @data  date,  @cd_emp int=1)
as
set nocount on;

Declare @ValorDesp money

SET @ValorDesp =isnull((SELECT SUM(vlr_desp) VLR_DESP
								FROM
									 v_pg_desp_rat
								WHERE tipo_lancto = 'PAGAR'
									  AND cd_emp = @cd_emp
									  AND dt_emis = @data
									  AND cd_filial = @filial),0);


SELECT
       20 AS tipoRegistro
     , I.dt_vd AS dataReferencia
     , SUM(I.vlr_dinh_it + I.vlr_chqs_it_vista) AS valorVendaVista
     , SUM(I.vlr_cartao_it) AS valorVendaCartao
     , SUM(I.vlr_chqs_it) AS valorVendaCheque
     , SUM((I.vlr_chqs_it_prazo + I.vlr_dup_it + I.vlr_conv_it)) AS valorVendaPrazo
     , SUM(I.tot_it) AS valorVendaMisto
     , SUM((I.qt_it * I.vlr_custo_medio)) AS valorCmv
     , 0 AS valorCustoFixo
     , 0 AS valorInvestimento
     , 0 AS valorReceitasNaoOperacionais
     , @ValorDesp AS valorDespesasNaoOperacionais	 
FROM
     v_pdv_vd_it I
WHERE I.cd_emp = @cd_emp
      AND I.dt_vd = @data
      AND I.cd_filial = @filial
GROUP BY
         I.dt_vd;